<?php
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Obține datele formularului
    $dbHost = $_POST['db_host'];
    $dbName = $_POST['db_name'];
    $dbUser = $_POST['db_user'];
    $dbPassword = $_POST['db_password'];

    $smtpServer = $_POST['smtp_server'];
    $smtpUser = $_POST['smtp_user'];
    $smtpPassword = password_hash($_POST['smtp_password'], PASSWORD_DEFAULT);
    $smtpPort = $_POST['smtp_port'];
    $smtpSsl = $_POST['smtp_ssl'] === 'Yes' ? true : false;

    $filePermitted = $_POST['file_permitted'];

    // Creează config.php în directorul rădăcină
    $configContent = "<?php\n";
    $configContent .= "return [\n";
    $configContent .= "    'db' => [\n";
    $configContent .= "        'host' => '$dbHost',\n";
    $configContent .= "        'name' => '$dbName',\n";
    $configContent .= "        'user' => '$dbUser',\n";
    $configContent .= "        'password' => '$dbPassword',\n";
    $configContent .= "    ],\n";
    $configContent .= "    'smtp' => [\n";
    $configContent .= "        'server' => '$smtpServer',\n";
    $configContent .= "        'user' => '$smtpUser',\n";
    $configContent .= "        'password' => '$smtpPassword',\n";
    $configContent .= "        'port' => '$smtpPort',\n";
    $configContent .= "        'ssl' => " . ($smtpSsl ? 'true' : 'false') . ",\n";
    $configContent .= "    ],\n";
    $configContent .= "    'files' => [\n";
    $configContent .= "        'permitted' => '$filePermitted',\n";
    $configContent .= "    ],\n";
    $configContent .= "];\n";

    file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/config.php', $configContent);
    echo "Config file generated successfully!";
} else {
?>

<!DOCTYPE html>
<html>
<head>
    <title>Install - File Sharing Server</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-GLhlTQ8iRABdZLl6O3oVMWSktQOp6b7In1Zl3/Jr59b6EGGoI1cXkkVOn1D8p3aM" crossorigin="anonymous">
    <style>
        body {
            background-color: #e0f7fa; /* Light blue background */
            overflow-y: auto; /* Enable scrolling if content overflows */
        }

        .modal-dialog {
            max-width: 600px;
            margin: auto; /* Center modal horizontally */
        }

        .modal-content {
            background-color: rgba(0, 0, 255, 0.7); /* Blue background with 70% opacity */
            color: white;
        }

        .modal-header, .modal-footer {
            border: none; /* Remove borders to match the style */
        }

        .modal-title {
            font-size: 1.2rem;
            font-weight: bold;
        }

        .btn-primary {
            background-color: #0056b3; /* Darker blue for buttons */
            border-color: #0056b3;
        }

        .form-control {
            width: 80%; /* Ensure inputs do not exceed 80% of modal width */
            background-color: #fff; /* White input fields */
            color: #000; /* Black text inside inputs */
        }

        label {
            display: block; /* Align labels to the left */
            margin-bottom: 5px; /* Space between label and input */
        }
    </style>
</head>
<body>

    <!-- Database Config Modal -->
    <div class="modal" id="dbConfigModal" tabindex="-1" aria-labelledby="dbConfigLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <!-- Modal header -->
                <div class="modal-header">
                    <h5 class="modal-title" id="dbConfigLabel">Now we put Database Connection data. Please be sure that you have already created a Database connection</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <!-- Modal body -->
                <div class="modal-body">
                    <form id="configForm" method="POST" action="">
                        <div class="mb-3">
                            <label for="db_host" class="form-label">Database Host:</label>
                            <input type="text" class="form-control" id="db_host" name="db_host" required>
                        </div>
                        <div class="mb-3">
                            <label for="db_name" class="form-label">Database Name:</label>
                            <input type="text" class="form-control" id="db_name" name="db_name" required>
                        </div>
                        <div class="mb-3">
                            <label for="db_user" class="form-label">Database User:</label>
                            <input type="text" class="form-control" id="db_user" name="db_user" required>
                        </div>
                        <div class="mb-3">
                            <label for="db_password" class="form-label">Database Password:</label>
                            <input type="password" class="form-control" id="db_password" name="db_password" required>
                        </div>
                    </form>
                </div>
                <!-- Modal footer -->
                <div class="modal-footer">
                    <button type="button" class="btn btn-primary" id="nextButton">Next</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal 2: SMTP and File Config -->
    <div class="modal" id="smtpConfigModal" tabindex="-1" aria-labelledby="smtpConfigLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <!-- Modal header -->
                <div class="modal-header">
                    <h5 class="modal-title" id="smtpConfigLabel">SMTP and File Configuration</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <!-- Modal body -->
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="smtp_server" class="form-label">SMTP Server:</label>
                        <input type="text" class="form-control" id="smtp_server" name="smtp_server" required>
                    </div>
                    <div class="mb-3">
                        <label for="smtp_user" class="form-label">SMTP User (Email):</label>
                        <input type="email" class="form-control" id="smtp_user" name="smtp_user" required>
                    </div>
                    <div class="mb-3">
                        <label for="smtp_password" class="form-label">SMTP Password:</label>
                        <input type="password" class="form-control" id="smtp_password" name="smtp_password" required>
                    </div>
                    <div class="mb-3">
                        <label for="smtp_port" class="form-label">SMTP Port:</label>
                        <input type="text" class="form-control" id="smtp_port" name="smtp_port" required>
                    </div>
                    <div class="mb-3">
                        <label for="smtp_ssl" class="form-label">Use SSL:</label>
                        <select class="form-select" id="smtp_ssl" name="smtp_ssl" required>
                            <option value="Yes">Yes</option>
                            <option value="No">No</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label for="file_permitted" class="form-label">Permitted File Extensions (comma separated):</label>
                        <input type="text" class="form-control" id="file_permitted" name="file_permitted" value="jpg,png,pdf,xlsx,docx,zip,7z,rar,xlsm" required>
                    </div>
                </div>
                <!-- Modal footer -->
                <div class="modal-footer">
                    <button type="button" class="btn btn-primary" id="generateConfigButton">Generate Config</button>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.10.2/dist/umd/popper.min.js" integrity="sha384-oBqDVmMz4fnFO9gybP1Yj5PhW8KOk4Hc7QmJJiF4R5F9t3pU5f6Yd4a6zYzRyXwN/j8cz9" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.min.js" integrity="sha384-mQ93QfsnXPsGcQ+AB9M8Nrr9dGHBgIc6ZZtl6DRT/QpzkfIJDRHVRK8oIFeupL5r" crossorigin="anonymous"></script>
    <script>
        // Show the DB Config modal on page load
        var dbModal = new bootstrap.Modal(document.getElementById('dbConfigModal'));
        dbModal.show();

        // Move to the second modal after clicking 'Next'
        document.getElementById('nextButton').addEventListener('click', function () {
            dbModal.hide(); // Hide the first modal
            var smtpModal = new bootstrap.Modal(document.getElementById('smtpConfigModal'));
            smtpModal.show(); // Show the second modal
        });

        // Generate Config button handler
        document.getElementById('generateConfigButton').addEventListener('click', function () {
            document.getElementById('configForm').submit();
        });
    </script>
</body>
</html>

<?php
}
?>
