<?php
// Detalii conexiune MySQL
$servername = "localhost";
$username = "servici_bigfileusr";
$password = "IntermezzO@0607";
$dbname = "servici_bigfile";

// Crearea conexiunii
$conn = new mysqli($servername, $username, $password, $dbname);

// Verificarea conexiunii
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Salvare traduceri
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['save_translations'])) {
    foreach ($_POST as $key => $value) {
        if (strpos($key, 'translation_') !== false) {
            $parts = explode('_', $key);
            $id = intval($parts[1]);  // ID-ul traducerii
            $language = $conn->real_escape_string($parts[2]) . '_translate';  // Limba cu sufixul _translate

            // Escaparea valorii pentru SQL
            $value = $conn->real_escape_string($value);

            // Execută interogarea SQL pentru actualizarea fiecărei traduceri
            $sql = "UPDATE translate SET `$language` = '$value' WHERE ID_translate = $id";
            if ($conn->query($sql) === FALSE) {
                echo "Eroare la actualizarea traducerii pentru ID $id și limba $language: " . $conn->error . "<br>";
            } else {
                echo "Traducerea pentru ID $id și limba $language a fost actualizată cu succes.<br>";
            }
        }
    }
}

// Paginare
$records_per_page = 10; // Înregistrări pe pagină
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$offset = ($page - 1) * $records_per_page;

// Preluare coloane din tabelul `translate`
$sql = "SHOW COLUMNS FROM translate";
$result = $conn->query($sql);
$columns = [];
while ($row = $result->fetch_assoc()) {
    $columns[] = $row['Field'];
}

// Preluare date existente cu limită pentru paginare
$sql = "SELECT * FROM translate LIMIT $records_per_page OFFSET $offset";
$result = $conn->query($sql);
$translations = [];
while ($row = $result->fetch_assoc()) {
    $translations[] = $row;
}

// Numărul total de înregistrări pentru paginare
$total_sql = "SELECT COUNT(*) FROM translate";
$total_result = $conn->query($total_sql);
$total_rows = $total_result->fetch_row()[0];
$total_pages = ceil($total_rows / $records_per_page);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Translation Management</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <div class="container">
        <h1>Translation Management</h1>

        <!-- Formular pentru salvarea traducerilor -->
        <form method="POST" class="form-container">
            <button type="submit" name="save_translations" class="save-btn">Save Translations</button>
            <table>
                <thead>
                    <tr>
                        <?php foreach ($columns as $column) { ?>
                            <th><?= $column ?>
                                <?php if ($column != 'ID_translate') { ?>
                                    <form method="POST" action="delete_language.php" style="display:inline;">
                                        <input type="hidden" name="language_to_delete" value="<?= $column ?>">
                                        <button type="submit" class="delete-btn">Delete</button>
                                    </form>
                                <?php } ?>
                            </th>
                        <?php } ?>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($translations as $row) { ?>
                        <tr>
                            <?php foreach ($columns as $column) { ?>
                                <td>
                                    <?php if ($column == 'ID_translate') { ?>
                                        <?= $row[$column] ?>
                                    <?php } else { ?>
                                        <textarea name="translation_<?= $row['ID_translate'] ?>_<?= rtrim($column, '_translate') ?>" style="min-height: 40px;"><?= htmlspecialchars($row[$column]) ?></textarea>
                                    <?php } ?>
                                </td>
                            <?php } ?>
                        </tr>
                    <?php } ?>
                </tbody>
            </table>
        </form>

        <!-- Paginare -->
        <div class="pagination">
            <?php if ($page > 1) { ?>
                <a href="?page=<?= $page - 1 ?>">Previous</a>
            <?php } ?>

            <?php for ($i = 1; $i <= $total_pages; $i++) { ?>
                <a href="?page=<?= $i ?>" <?= $i == $page ? 'class="active"' : '' ?>><?= $i ?></a>
            <?php } ?>

            <?php if ($page < $total_pages) { ?>
                <a href="?page=<?= $page + 1 ?>">Next</a>
            <?php } ?>
        </div>

        <!-- Formular pentru adăugarea unei noi limbi -->
        <form method="POST" action="add_language.php" class="form-container">
            <input type="text" name="new_language" placeholder="Add New Language" required>
            <button type="submit" name="add_language" class="add-btn">Add Language</button>
        </form>

        <!-- Formular pentru adăugarea unei noi înregistrări în tabelul translate -->
        <h2>Add New Translation Entry</h2>
        <form method="POST" action="add_translation.php" class="form-container">
            <?php foreach ($columns as $column) { ?>
                <?php if ($column != 'ID_translate') { ?>
                    <input type="text" name="<?= rtrim($column, '_translate') ?>" placeholder="<?= rtrim($column, '_translate') ?>" required>
                <?php } ?>
            <?php } ?>
            <button type="submit" name="add_translation" class="add-btn">Add Translation</button>
        </form>
    </div>
</body>
</html>
