<?php
$servername = "localhost";
$username = "servici_bigfileusr";
$password = "IntermezzO@0607";
$dbname = "servici_bigfile";

// Crearea conexiunii
$conn = new mysqli($servername, $username, $password, $dbname);

// Verificarea conexiunii
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Funcție pentru a adăuga o traducere
function addTranslation($conn, $data) {
    $columns = implode(", ", array_keys($data));
    $placeholders = implode(", ", array_fill(0, count($data), '?'));
    
    $sql = "INSERT INTO translate ($columns) VALUES ($placeholders)";
    $stmt = $conn->prepare($sql);

    // Generăm tipurile de date pentru bind_param
    $types = str_repeat('s', count($data));
    
    // Creăm un array cu valorile pentru bind_param
    $values = array_values($data);
    $stmt->bind_param($types, ...$values); // Folosim unpacking
    $stmt->execute();
    $stmt->close();
}

// Funcție pentru a salva o traducere existentă
function saveTranslation($conn, $id, $data) {
    $setClause = [];
    foreach ($data as $key => $value) {
        $setClause[] = "$key = ?";
    }
    $setClause = implode(", ", $setClause);
    
    $sql = "UPDATE translate SET $setClause WHERE ID_translate = ?";
    $stmt = $conn->prepare($sql);

    // Generăm tipurile de date pentru bind_param
    $types = str_repeat('s', count($data)) . 'i'; // 'i' pentru ID
    $values = array_values($data);
    $values[] = $id; // Adăugăm ID-ul la sfârșit
    $stmt->bind_param($types, ...$values); // Folosim unpacking
    $stmt->execute();
    $stmt->close();
}

// Procesare formular
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    if (isset($_POST['add_translation'])) {
        $data = [];
        foreach ($_POST as $key => $value) {
            if ($key !== 'add_translation') {
                $data[$key] = $value;
            }
        }
        addTranslation($conn, $data);
    } elseif (isset($_POST['save_translation'])) {
        $id = $_POST['id'];
        $data = [];
        foreach ($_POST as $key => $value) {
            if ($key !== 'save_translation' && $key !== 'id') {
                $data[$key] = $value;
            }
        }
        saveTranslation($conn, $id, $data);
    }
}

// Obține coloanele existente
$sql = "SHOW COLUMNS FROM translate";
$columnsResult = $conn->query($sql);
$columns = [];
while ($row = $columnsResult->fetch_assoc()) {
    $columns[] = $row['Field'];
}

// Obține toate traducerile existente
$sql = "SELECT * FROM translate";
$result = $conn->query($sql);
?>

<!DOCTYPE html>
<html lang="ro">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Traduceri</title>
    <link rel="stylesheet" href="style.css"> <!-- Include stilul CSS actualizat -->
</head>
<body>
    <div class="container">
        <h1>Adăugare traduceri</h1>
        
        <form method="POST">
            <?php foreach ($columns as $column) {
                if ($column !== 'ID_translate') { // Ignorăm ID-ul
                    echo "<input type='text' name='$column' placeholder='$column' required>";
                }
            } ?>
            <button type="submit" name="add_translation" class="add-btn">Adaugă Traducere</button>
        </form>

        <h2>Înregistrări existente</h2>
        <table>
            <tr>
                <th>ID</th>
                <?php foreach ($columns as $column) {
                    if ($column !== 'ID_translate') {
                        echo "<th>$column</th>";
                    }
                } ?>
                <th>Acțiune</th>
            </tr>
            <?php while ($row = $result->fetch_assoc()) { ?>
                <tr>
                    <form method="POST">
                        <td><?php echo $row['ID_translate']; ?></td>
                        <?php foreach ($columns as $column) {
                            if ($column !== 'ID_translate') {
                                echo "<td><input type='text' name='$column' value='" . $row[$column] . "' required></td>";
                            }
                        } ?>
                        <td>
                            <input type="hidden" name="id" value="<?php echo $row['ID_translate']; ?>">
                            <button type="submit" name="save_translation" class="save-btn">Salvează</button>
                        </td>
                    </form>
                </tr>
            <?php } ?>
        </table>

        <h2>Adăugare limbă nouă</h2>
        <form method="POST" action="add_language.php">
            <input type="text" name="new_language" placeholder="Nume limbă" required>
            <button type="submit" class="add-btn">Adaugă Limbă</button>
        </form>
    </div>
</body>
</html>

<?php
